/**
 * @file   : dribbler.h (1.0)
 * @brief  : dribble the ball
 * @author : Shinnosuke KOIKE
 * @date   : 2015/08/11
 */

#ifndef DRIBBLER_H
#define DRIBBLER_H

#include "mbed.h"
#include "motor.h"

class Dribbler {
public:
    Dribbler(PinName normalDirect, PinName reverseDirect, PinName pwm, PinName dribblerIR_);
    void dribble(float power);

private:
    DigitalIn dribblerIR;
    Motor dribblerMotor;
};

Dribbler::Dribbler(PinName normalDirect, PinName reverseDirect, PinName pwm, PinName dribblerIR_) :
        dribblerIR(dribblerIR_), dribblerMotor(normalDirect, reverseDirect, pwm) {
    dribblerMotor.setLimit(0.8);
}

void Dribbler::dribble(float power) {
    if (dribblerIR == 0) {
        dribblerMotor.run(power);
    } else {
        dribblerMotor.brake();
    }
}

#endif

/**
 * example program

#include "mbed.h"
#include "dribbler.h"

int main(void) {
    Dribbler dribbler(D4, D7, D9, D0);
    while (1) {
        dribbler.dribble(0.2);
    }
}
 */
