/**
 * @file   : compass.h (1.0)
 * @brief  : measure angle
 * @author : Shinnosuke KOIKE
 * @date   : 2015/08/04
 */

#ifndef COMPASS_H
#define COMPASS_H

#include "mbed.h"
#include "HMC6352.h"

class Compass {
public:
    Compass(PinName sda, PinName scl);
    ~Compass();
    float measureAngle(void);

private:
    float initialAngle;
    HMC6352* hmc6352;
};

// initialize and set initial angle
Compass::Compass(PinName sda, PinName scl) {
    hmc6352 = new HMC6352(sda, scl);
    hmc6352->setOpMode(HMC6352_CONTINUOUS, 1, 20);
    wait(0.1);
    this->initialAngle = hmc6352->sample() / 10.0;
}

Compass::~Compass() {
    delete hmc6352;
}

// return difference of angle
float Compass::measureAngle(void) {
    wait(0.1);
    float diffAngle = hmc6352->sample() / 10.0 - initialAngle;
    return diffAngle;
}

#endif

/**
 * example program

#include "mbed.h"
#include "compass.h"

int main(void) {
    Compass compass(D14, D15);
    while (1) {
        pc.printf("%f\r\n", compass.measureAngle()); // for example, display "130.143..."
    }
}
 */
