/**
 * @file   : infrared.h (1.0)
 * @brief  : examine point the ball exist
 * @author : Shinnosuke KOIKE
 * @date   : 2015/08/04
 */
 
#ifndef INFRARED_H
#define INFRARED_H

#include "mbed.h"

class Infrared {
public:
    Infrared(PinName front, PinName frontLeft, PinName left, PinName backLeft,
        PinName back, PinName backRight, PinName right, PinName frontRight);
    char findBallPos(void);

private:
    BusIn infraredData;
};

class AnalogInfrared {
public:
    AnalogInfrared(PinName front, PinName frontLeft, PinName left, PinName backLeft,
        PinName back, PinName backRight, PinName right, PinName frontRight);
    void findBallPosAndDist(char data[]);

private:
    AnalogIn analogFront;
    AnalogIn analogFrontLeft;
    AnalogIn analogLeft;
    AnalogIn analogBackLeft;
    AnalogIn analogBack;
    AnalogIn analogBackRight;
    AnalogIn analogRight;
    AnalogIn analogFrontRight;
};

// initialize
Infrared::Infrared(PinName front, PinName frontLeft, PinName left, PinName backLeft,
        PinName back, PinName backRight, PinName right, PinName frontRight):
    infraredData(front, frontLeft, left, backLeft, back, backRight, right, frontRight) {
}

// return ball position
char Infrared::findBallPos(void) {
    char data = infraredData;
    return data;
}

// initialize
AnalogInfrared::AnalogInfrared(PinName front, PinName frontLeft, PinName left, PinName backLeft,
        PinName back, PinName backRight, PinName right, PinName frontRight):
    analogFront(front), analogFrontLeft(frontLeft), analogLeft(left), analogBackLeft(backLeft),
    analogBack(back), analogBackRight(backRight), analogRight(right), analogFrontRight(frontRight) {
}

// return ball position and distance
void AnalogInfrared::findBallPosAndDist(char data[]) {
    data[0] = analogFront;
    data[1] = analogFrontLeft;
    data[2] = analogLeft;
    data[3] = analogBackLeft;
    data[4] = analogBack;
    data[5] = analogBackRight;
    data[6] = analogRight;
    data[7] = analogFrontRight;
}

#endif

/**
 * example program(normal)

#include "mbed.h"
#include "infrared.h"

int main(void) {
    Infrared infrared(D0, D1, D2, D3, D4, D5, D6, D7);
    while (1) {
        char data = infrared.findBallPos();
        pc.printf("%d\r\n", data);  // for example, display "11000001"
    }
}

 * example program(analog)

#include "mbed.h"
#include "infrared.h"

int main(void) {
    int data[8];
    AnalogInfrared analogInfrared(D0, D1, D2, D3, D4, D5, D6, D7);
    while (1) {
        analogInfrared.findBallPosAndDist(data);
        for (int i = 0; i < 8; i++) {
            pc.printf("%f\r\n", data[i]);   // for example, display "123, 212, 0, 0, ..."
        }
    }
}
 */
