/**
 * @file   : kicker.h (1.0)
 * @brief  : kick the ball
 * @author : Shinnosuke KOIKE
 * @date   : 2015/08/08
 */

#ifndef KICKER_H
#define KICKER_H

#include "mbed.h"

class Kicker {
public:
    Kicker(PinName kicker_, PinName brightness_);
    ~Kicker();
    void kick(void);

private:
    DigitalOut kicker;
    DigitalIn  brightness;
    Timer timer;
    bool enableKick;
    void count(void);
};

// initialize
Kicker::Kicker(PinName kicker_, PinName brightness_):
    kicker(kicker_), brightness(brightness_) {
}

// end timer
Kicker::~Kicker() {
    timer.reset();
    timer.stop();
}

// count and set a kick flag
void Kicker::count(void) {
    timer.start();
    float val = timer.read();
    if (val >= 2) {
        this->enableKick = 1;
    }
}

// if ball exist before their's eyes and was set a kick flag, kick the ball
void Kicker::kick(void) {
    this->count();
    if (brightness == 0 && enableKick == 1) {
        kicker = 1;
        timer.reset();
        this->enableKick = 0;
    }
}

#endif

/**
 * example program

#include "mbed.h"
#include "kicker.h"

int main(void) {
    Kicker kicker(D0, D1);
    while (1) {
        kicker.kick();
    }
}
 */
