#include "mbed.h"

int mode_debug = 0; //printf()表示



//走行用プログラム
//モータードライバー＋回転数計測プログラム
//走るためのプログラム+道が白か黒かを判定するプログラム
//A入力に右のモーター、B入力に左のモーター
//58mm径タイヤの一周は約182.21mm

PwmOut AIN1(D6);//右モーター
PwmOut AIN2(D5);
PwmOut BIN1(D9);//左モーター
PwmOut BIN2(D10);//D9とD10は回路上で逆にしないと、なぜか回転方向が逆転


DigitalOut myled(A5);//200mmごとに光らせるLED用
DigitalOut power_on_led(A6);//電源オン時に光らせるLED用

AnalogIn sensor_R(A0);//進行方向右のフォトリフレクタセンサー    
AnalogIn sensor_L(A2);//進行方向左のセンサー
AnalogIn sensor_C(A1);//中央配置のセンサー


InterruptIn enc_R(D11);//フォトインタラプタ右
InterruptIn enc_L(D12);//フォトインタラプタ左

//デューティー比関連の変数、定数
const float roll_duty_small = 0.18;//弱転回時の展開方向車輪duty
const float roll_duty_basic = 0.23f;//基本のduty(直進、弱右折時左車輪、弱左折時右車輪)
const float hosei_L=0.06f;
const float hosei_R=0.0f;
const float sharp_roll_duty_out = 0.25f;//急カーブ時に作用    超信地旋回   白白白//0.25
const float sharp_roll_duty_in = 0.0f;//急カーブ時に作用    超信地旋回   白白白//0.25
const float ignition_duty = 0.7f;
/*フォトリフレクタセンサ関連の定数

const float L_black = 2.4;//左センサの黒値
const float L_white = 1.2;//白値
const float R_black = 1.4;//右センサの黒値
const float R_white = 0.6;//
const float C_black = 2.2(1.5まで);//中心センサの黒値
const float C_white = 0.6;//
*/

float L_target = 0.65;
float R_target = 0.35;
float C_target = 0.50;

//回転数関連の変数、定数
float R_rot=0;//右タイヤの１秒間あたり回転数
float L_rot=0;
float pre_R_rot=0;//1つ前の過程の右モーターの累計回転数
float pre_L_rot=0;
float R_target_rot=0;//１秒間あたりの右目標タイヤ回転数
float L_target_rot=0;//１秒間あたりの左目標タイヤ回転数
float counter_R =0;//右モーターの累計回転数
float pre_counter_R = 0;//1つ前の過程の右のモーターの累計回転数
float counter_L =0;
float pre_counter_L = 0;

//距離、時間関係の変数、定数
float distance_per_frame = 0.0f;//距離の初期値
float total_distance = 0.0f;//距離のトータル
float delta = 0.01;//計測、判断時間の周期

/*
//モーター回転数計測
void event_handler_R(void){//右モーター回転数計測
    counter_R++;
}

void event_handler_L(void){//左モーター
    counter_L++;
}
*/


//ブレーキ

void motorStop(PwmOut IN1,PwmOut IN2) {
    IN1 = 1;
    IN2 = 1;
}

//正転

void motorForward(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = duty;
    IN2 = 0;
}

//逆転
void motorReverse(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = 0;
    IN2 = duty;
}
//空転
void motorIdling(PwmOut IN1,PwmOut IN2) {
    IN1 = 0;
    IN2 = 0;
}


//==========================================
void motor_input(void)
{
    if(mode_debug==1)
    {    
    printf("sensor_R:L432[%.3f]>\n",sensor_R*3.3F);//電圧測定
    printf("sensor_L:L432[%.3f]>\n",sensor_L*3.3F);//電圧測定
    printf("sensor_C:L432[%.3f]>\n\n",sensor_C*3.3F);//電圧測定  
    }
    if(sensor_C*3.3F > C_target)//中央が黒
    {
        if(sensor_R*3.3F > R_target)//右が黒>弱右折>左が強め
        {
            motorReverse(AIN1,AIN2,roll_duty_small);//R
            motorReverse(BIN1,BIN2,roll_duty_basic);//L
        }
        else if(sensor_L*3.3F > L_target)//左が黒>弱左折>右が強め
        {
            motorReverse(AIN1,AIN2,roll_duty_basic + hosei_R);//R
            motorReverse(BIN1,BIN2,roll_duty_small);//L
        }
        else{//黒黒黒or白黒白＞直進
            motorReverse(AIN1,AIN2,roll_duty_basic+ hosei_R);//R
            motorReverse(BIN1,BIN2,roll_duty_basic+ hosei_L);//L
        }
    }
    else//中央が白
    {
        if(sensor_L*3.3F > L_target)//左が黒
        {
            while(sensor_C*3.3F < C_target)//中央が白の間は右に曲がり続ける
            {
                /*                if(sensor_L*3.3F < L_target){
                    motorForward(AIN1,AIN2,sharp_roll_duty_out);
                    motorReverse(BIN1,BIN2,sharp_roll_duty_out);
                }else{
                */
                    motorReverse(AIN1,AIN2,sharp_roll_duty_in+hosei_R);
                    motorReverse(BIN1,BIN2,sharp_roll_duty_out);
                               
            }
        }
        else if(sensor_R*3.3F > R_target)//右が黒
        {
            while(sensor_C*3.3F < C_target)//中央が白の間は左に曲がり続ける
            {
                /*if(sensor_R*3.3F < R_target){
                    motorReverse(AIN1,AIN2,sharp_roll_duty_out);
                    motorReverse(BIN1,BIN2,sharp_roll_duty_out);
                }else{
                    */
                    motorReverse(AIN1,AIN2,sharp_roll_duty_out);
                    motorReverse(BIN1,BIN2,sharp_roll_duty_in+hosei_L);
               // }
            }
            
            
        }
        else//白白白>直進・・・なんで？
        {
            motorReverse(AIN1,AIN2,sharp_roll_duty_out);
            motorReverse(BIN1,BIN2,sharp_roll_duty_out);
        }
    }
}
//==========================================

/*
void distance_calculate (void)
{
    R_rot = (counter_R-pre_counter_R)/24.0f/38.2f/delta;//一秒間当たりの右タイヤ回転数の計算
    L_rot = (counter_L-pre_counter_L)/24.0f/38.2f/delta;
    distance_per_frame = (R_rot+L_rot)/2.0f*182.12f;//右の回転数と左の回転数の平均に、一周の距離をかける
    if(distance_per_frame ==0.0f){
        motorReverse(AIN1,AIN2,ignition_duty);
        motorReverse(BIN1,BIN2,ignition_duty);
    }
    total_distance += distance_per_frame;
//    printf("Total Distance [%f]     Distance per Frame [%f]\n",total_distance,distance_per_frame);
//    printf("rotation  per second R[%f]  L[%f]\n",R_rot,L_rot);
    distance_per_frame = 0;

}

//LED点灯プログラム
void led_lightning(float total_distance)
{
    int period_100mm =0;
    for (int i =0;i<500;i++)
    {
        if( total_distance >= (float)i*200 && total_distance < ((float)i+1)*200)
        {
            period_100mm = i;
            break;
        }
    }        
    if(period_100mm%2 == 1)
    {
        myled = 1;
//        printf("LED IS [ON]\n");
        
    }else
    {
            myled = 0;
//            printf("LED IS [OFF]\n\n\n");
    }
}

*/


int main() {    
    AIN1.period(0.001);
    AIN2.period(0.001);
    BIN1.period(0.001);
    BIN2.period(0.001);
    
/*    enc_R.rise(&event_handler_R);
    enc_R.fall(&event_handler_R);
    enc_L.rise(&event_handler_L);
    enc_L.fall(&event_handler_L);
*/    
    power_on_led=1;
    
    
    while(1) {
        motor_input();
//        distance_calculate();
//        led_lightning(total_distance);
    }
} 