#include "mbed.h"

//走行用プログラムver4(P制御）
//11/1
//モータードライバー＋回転数計測プログラム
//走るためのプログラム+道が白か黒かを判定するプログラム
//A入力に右のモーター、B入力に左のモーター
//58mm径タイヤの一周は約182.21mm


InterruptIn enc_R(D12);//フォトインタラプタ右
InterruptIn enc_L(D11);//フォトインタラプタ左

AnalogIn sensor_R(A0);//進行方向右のフォトリフレクタセンサー    
AnalogIn sensor_L(A2);//進行方向左のセンサー
AnalogIn sensor_C(A1);//中央配置のセンサー

DigitalOut myled(LED1);

float counter_R =0;
float pre_counter_R = 0; //左右の回転数変化量を読み取るための前値
void event_handler_R(void){
    counter_R++;
}

float counter_L =0;
float pre_counter_L = 0;
void event_handler_L(void){//左モーター
    counter_L++;
}


//距離測定

float machine_distance(float distance){
    //1回転で進む距離は182.12mmここでは180mmと近似する、
    enc_R.rise(&event_handler_R);
    enc_R.fall(&event_handler_R);
    enc_L.rise(&event_handler_L);
    enc_L.fall(&event_handler_L);

    return (counter_R + counter_L)/38.2/24.0* 182.12/ 2.0;//右の回転数と左の回転数の平均に、一周の距離をかける
}

void distance_checker (float distance)
{
    float new_distance = machine_distance(distance);
    printf("Total Distance [%f]     Distance per Frame [%f]\n",new_distance, new_distance - distance);
    distance = new_distance;
    printf("Left and right rotation speed per frame R[%f]  L[%f]\n",(counter_R - pre_counter_R)/12.0/38.2,(counter_L - pre_counter_L)/12.0/38.2);
    pre_counter_R = counter_R;
    pre_counter_L = counter_L;   
}

//LED点灯プログラム
void led_lightning(float distance)
{
    int period_100mm =0;
    for (int i =0;i<500;i++)
    {
        if( distance >= i*200 && distance < (i+1)*200)
        {
            period_100mm = i;
            break;
        }
    }        
    if(period_100mm%2 == 1)
    {
        myled = 1;
    }else
    {
            myled = 0;
    }
}
     

PwmOut AIN1(D6);//左モーター
PwmOut AIN2(D5);
PwmOut BIN1(D9);//右モーター
PwmOut BIN2(D10);//D9とD10は回路上で逆にしないと、なぜか回転方向が逆転
 
//ブレーキ
void motorStop(PwmOut IN1,PwmOut IN2) {
    IN1 = 1;
    IN2 = 1;
}

//正転
void motorForward(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = duty;
    IN2 = 0;
}

//逆転
void motorReverse(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = 0;
    IN2 = duty;
}
//空転
void motorIdling(PwmOut IN1,PwmOut IN2) {
    IN1 = 0;
    IN2 = 0;
}


    
    

//停止
void machine_Stop(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2) {
    motorStop(AIN1,AIN2);
    motorStop(BIN1,BIN2);
}


//前進
void machine_Forward(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {
    motorReverse(AIN1,AIN2,duty);//逆転のほうが制御しやすいので前進時は逆転を使用
    motorReverse(BIN1,BIN2,duty);
}

//後退
void machine_Back(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {
    machine_Stop(AIN1,AIN2,BIN1,BIN2);
    wait(2);
    motorForward(AIN1,AIN2,duty);
    motorForward(BIN1,BIN2,duty);
}

//右カーブ
void Right_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty_basic,float duty_ad) {

    motorReverse(AIN1,AIN2,duty_basic-duty_ad);
    motorReverse(BIN1,BIN2,duty_basic+duty_ad);
}

//左カーブ
void Left_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty_basic,float duty_ad) {

    motorReverse(AIN1,AIN2,duty_basic+duty_ad);
    motorReverse(BIN1,BIN2,duty_basic-duty_ad);
}


//右急カーブ
void Right_high_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty,float duty_ad_sharp) {


    motorIdling(AIN1,AIN2);
    motorReverse(BIN1,BIN2,duty+duty_ad_sharp);
}

//左急カーブ
void Left_high_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty,float duty_ad_sharp) {


    motorReverse(AIN1,AIN2,duty+duty_ad_sharp);
    motorIdling(BIN1,BIN2);
}


        
//最終的には
//左のモーターのスピード変更量 = 比例ゲイン×（左のセンサ値 - 左の黒値） / （左の白値 - 左の黒値）＋基本最低スピード
//右のモーターのスピード変更量 = 比例ゲイン×（右のセンサ値 - 右の黒値） / （右の白値 - 右の黒値）＋基本最低スピード

//白値はセンサーで白を検出する最小値
//黒値はセンサーで黒を検出する最大値
//tera termでそれぞれ最大、最小を見る

const float L_black = 2.8;//左モーターの黒値
const float L_white = 0.80;//白値
const float R_black = 2.5;//右モーターの黒値
const float R_white = 0.20;//
const float C_black = 2.5;//右モーターの黒値
const float C_white = 0.10;//


//目標値決定
            /*if(sensor_C*3.3f>1.0f){//中央センサーが黒
                 gray -=0.1f;//目標値を下げ
                 }
                 */
float L_target = (L_black + L_white) / 2;
float R_target = (R_black + R_white) / 2;
float C_target = (C_black + C_white) / 2;

//const float p_gain=0.070;// Pゲイン変数Kp
//const float L_p_gain=

//（目標値　ー　センサ値）×　Kp　⇒　10% ~ －10%の制御範囲になるようにKpを決めた
//目標値:1.0(3.3倍した後の数値)
//センサー値:0~2の間くらい(3.3倍した後の数値)

enum branch_mode{//制御の状態記号
    STRAIGHT =0,
    RIGHT,
    LEFT,
    SHARP_R,
    SHARP_L,
    REVERSE
    };
    
int mode;//展開中の制御状態記号の格納
int pre_mode;//一つ前の状態記号の格納:線を外れた際に引用

enum restart_ignition{//減速後の復帰のための操作に使用する信号
    no=0,
    ready,
    yes
    };
    
int re_ignition;//上restart_ignitionの格納

void ignition_check(){
    if(re_ignition == ready){
        re_ignition = yes;
        }
    }
/*
restart_ignitionについて

[re_ignition = no]では、通常の走行状態
[re_ignition = ready]は急カーブ中の状態
この状態で中央のセンサーが黒を感知すると[re_ignition = yes]となり、
一時的にduty比を上げて、走行させる。その後[re_ignition = no]に戻る。
*/

void Check_reflecter(AnalogIn sensor_R, AnalogIn sensor_L,AnalogIn sensor_C){//リフレクタの黒白判定＆移動方向の決定
    int R_on_off =0;//左右の白黒
    int L_on_off =0;
    int C_on_off =0;
    printf("sensor_Right:L432[%.3f]>\n",sensor_R*3.3F);//電圧測定
    printf("sensor_Left:L432[%.3f]>\n",sensor_L*3.3F);//電圧測定
    printf("sensor_Center:L432[%.3f]>\n\n",sensor_C*3.3F);//電圧測定  

    if(sensor_R*3.3F>R_target)
    {
        R_on_off=1;
    }
    if(sensor_L*3.3F>L_target)
    {
        L_on_off=1;
    }
    if(sensor_C*3.3F>C_target)
    {
        C_on_off=1;
    }
    printf("Judgement of sensor L[%d] C[%d] R[%d]\n",L_on_off,C_on_off,R_on_off);//[1]なら黒判定
    
    
    if(L_on_off==0 && C_on_off==0 && R_on_off==0)//線の外
    {
        printf("I'm going out of line! Previous condition is %d \n",pre_mode);
        mode = pre_mode;
    }
    else if(L_on_off==1 && C_on_off==0 && R_on_off==0)//急左折
    {
        mode = SHARP_L;
        printf("SHARP_L\n");
    }
    else if(L_on_off==0 && C_on_off==0 && R_on_off==1)//急右折
    {
        mode = SHARP_R;
        printf("SHARP_R\n");
    }
    else if(L_on_off==1 && C_on_off==0 && R_on_off==1)//黒白黒、エラー、back
    {
        mode = REVERSE;
        ignition_check();
        printf("REVERSE\n");
    }
    else if(L_on_off==0 && C_on_off==1 && R_on_off==0)//前進
    {
        mode = STRAIGHT;
        ignition_check();
        printf("STRAIGHT\n");
    }
    else if(L_on_off==1 && C_on_off==1 && R_on_off==0)//左折
    {
        mode = LEFT;
        ignition_check();
        printf("LEFT\n");
    }
    else if(L_on_off==0 && C_on_off==1 && R_on_off==1)//右折
    {
        mode = RIGHT;
        ignition_check();
        printf("RIGHT\n");
    }
    else if(L_on_off==1 && C_on_off==1 && R_on_off==1)//all black（空中or十字部)よって直進
    {
        mode = STRAIGHT;
        ignition_check();
        printf("STRAIGHT\n");
    }
    pre_mode = mode;
}
        
    
//条件分岐
void Conditional_branch(float duty_basic, float duty_ad, float duty_ad_sharp,float duty_ignition)//移動方向に対する操作
{
    if (re_ignition == yes){//急カーブ後のイグニッション
        machine_Stop(AIN1,AIN2,BIN1,BIN2);
        wait(0.2);
        machine_Forward(AIN1,AIN2,BIN1,BIN2,duty_ignition);
        wait(0.02);
        re_ignition = no;
        printf("Fireeeeeeee!\n");
        }
        
    if (mode == STRAIGHT)
    {
        machine_Forward(AIN1,AIN2,BIN1,BIN2,duty_basic);
    }
    else if (mode == LEFT)
    {
        Left_rotation(AIN1,AIN2,BIN1,BIN2,duty_basic,duty_ad);
    }
    else if (mode ==RIGHT)
    {
        Right_rotation(AIN1,AIN2,BIN1,BIN2,duty_basic,duty_ad);
    }
    else if (mode ==SHARP_L)
    {
        Left_high_rotation(AIN1,AIN2,BIN1,BIN2,duty_basic,duty_ad_sharp);
        re_ignition = ready;
    }
    else if (mode ==SHARP_R)
    {
        Right_high_rotation(AIN1,AIN2,BIN1,BIN2,duty_basic,duty_ad_sharp);
        re_ignition = ready;
    }
    else if (mode == REVERSE)
    {
        machine_Back(AIN1,AIN2,BIN1,BIN2,duty_basic);
    }
    printf("ignition:%d\n",re_ignition);
}
        


/*//モーターのp制御
void motor_p_control(PwmOut IN1,PwmOut IN2,AnalogIn sensor,float duty,float target,float gain){
            // P制御による旋回

            float turn = 0;
            turn = gain * (target- sensor*3.3F );
            
            if (0.15f < turn) {
                turn = 0.15;
            } else if (turn < -0.15f) {
                turn = -0.15;
            }
 
            printf("turn value:%f\n",turn);
            printf("speed value:%f\n",duty+turn);
        
            motorReverse(IN1,IN2,duty+turn);                                                                                                                                                                               
}
 
//マシンのp制御
void machine_p_control(AnalogIn sensor_R,AnalogIn sensor_L,AnalogIn sensor_C,float duty){
    float gain = p_gain;
    float L_duty = duty;
    float R_duty = duty;
    Conditional_branch(sensor_R,sensor_L,sensor_C,R_duty,L_duty,gain);
    motor_p_control(BIN1,BIN2,sensor_L,L_duty,L_target,gain);//左のモーター制御
    motor_p_control(AIN1,AIN2,sensor_R,R_duty,R_target,gain);//右のモーター制御
}

    
    
*/
int main() {    
    AIN1.period(0.01);
    AIN2.period(0.01);
    BIN1.period(0.01);
    BIN2.period(0.01);
    
    machine_Stop(AIN1,AIN2,BIN1,BIN2);
    mode = STRAIGHT;
    re_ignition=no;
    float duty_basic = 0.155f;
    float duty_ad = 0.02f;
    float duty_ad_sharp = 0.1f;
    float duty_ignition = 0.7f;
    float distance = 0.0f;
      
    while(1) {
        wait(0.01);
        Check_reflecter(sensor_R,sensor_L,sensor_C);
        Conditional_branch(duty_basic,duty_ad,duty_ad_sharp,duty_ignition);
        distance_checker (distance);
     //   wait(2);
//      led_lightning(enc_R,enc_L,myled,i,distance);
    }
}