#include "mbed.h"

//走行用プログラムver4(P制御）
//11/1
//モータードライバー＋回転数計測プログラム
//走るためのプログラム+道が白か黒かを判定するプログラム
//A入力に右のモーター、B入力に左のモーター
//58mm径タイヤの一周は約182.21mm


InterruptIn enc_R(D12);//フォトインタラプタ右
InterruptIn enc_L(D11);//フォトインタラプタ左

AnalogIn sensor_R(A0);//進行方向右のフォトリフレクタセンサー    
AnalogIn sensor_L(A2);//進行方向左のセンサー
AnalogIn sensor_C(A1);//中央配置のセンサー

DigitalOut myled(LED1);

float counter_R =0;
void event_handler_R(void){
    counter_R++;
}

float counter_L =0;
void event_handler_L(void){//左モーター
    counter_L++;
}


//距離測定

float machine_distance(InterruptIn enc_R,InterruptIn enc_L,float distance){
    //1回転で進む距離は182.12mmここでは180mmと近似する、
    enc_R.rise(&event_handler_R);
    enc_R.fall(&event_handler_R);
    enc_L.rise(&event_handler_L);
    enc_L.fall(&event_handler_L);

    distance +=(counter_R + counter_L)* 180/ 2;//右の回転数と左の回転数の平均に、一周の距離をかける
    return distance;
}


/*
//LED点灯プログラム
void led_lightning(InterruptIn enc_R,InterruptIn enc_L,DigitalOut myled,float *i,float distance){
        if(machine_distance(enc_R,enc_L,distance)>= 100*(*i)){
            if((*i)%2==1){
                myled = 1;
                (*i)++;
            }
            if((*i)%2==0){
                myled = 0;
                (*i)++;
            }
        }
}
*/

PwmOut AIN1(D6);//左モーター
PwmOut AIN2(D5);
PwmOut BIN1(D9);//右モーター
PwmOut BIN2(D10);//D9とD10は回路上で逆にしないと、なぜか回転方向が逆転
 
 
void motorStop(PwmOut IN1,PwmOut IN2) {
    IN1 = 1;
    IN2 = 1;
}

//正転
void motorForward(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = duty;
    IN2 = 0;
}

//逆転
void motorReverse(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = 0;
    IN2 = duty;
}

    
    

//停止
void machine_Stop(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2) {
    motorStop(AIN1,AIN2);
    motorStop(BIN1,BIN2);
}


//前進
void machine_Forward(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {
    motorReverse(AIN1,AIN2,duty);//逆転のほうが制御しやすいので前進時は逆転を使用
    motorReverse(BIN1,BIN2,duty);
}

//後退
void machine_Back(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {
    machine_Stop(AIN1,AIN2,BIN1,BIN2);
    wait(2);
    motorForward(AIN1,AIN2,duty);
    motorForward(BIN1,BIN2,duty);
}

//右カーブ
void Right_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty_basic,float duty_ad) {

    motorReverse(AIN1,AIN2,duty_basic-duty_ad);
    motorReverse(BIN1,BIN2,duty_basic+duty_ad);
}

//左カーブ
void Left_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty_basic,float duty_ad) {

    motorReverse(AIN1,AIN2,duty_basic+duty_ad);
    motorReverse(BIN1,BIN2,duty_basic-duty_ad);
}


//右急カーブ
void Right_high_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {


    motorStop(AIN1,AIN2);
    motorReverse(BIN1,BIN2,duty);
}

//左急カーブ
void Left_high_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {


    motorReverse(AIN1,AIN2,duty);
    motorStop(BIN1,BIN2);
}


        
//最終的には
//左のモーターのスピード変更量 = 比例ゲイン×（左のセンサ値 - 左の黒値） / （左の白値 - 左の黒値）＋基本最低スピード
//右のモーターのスピード変更量 = 比例ゲイン×（右のセンサ値 - 右の黒値） / （右の白値 - 右の黒値）＋基本最低スピード

//白値はセンサーで白を検出する最小値
//黒値はセンサーで黒を検出する最大値
//tera termでそれぞれ最大、最小を見る

const float L_black = 2.8;//左モーターの黒値
const float L_white = 0.80;//白値
const float R_black = 2.5;//右モーターの黒値
const float R_white = 0.20;//
const float C_black = 2.5;//右モーターの黒値
const float C_white = 0.10;//


//目標値決定
            /*if(sensor_C*3.3f>1.0f){//中央センサーが黒
                 gray -=0.1f;//目標値を下げ
                 }
                 */
float L_target = (L_black + L_white) / 2;
float R_target = (R_black + R_white) / 2;
float C_target = (C_black + C_white) / 2;

//const float p_gain=0.070;// Pゲイン変数Kp
//const float L_p_gain=

//（目標値　ー　センサ値）×　Kp　⇒　10% ~ －10%の制御範囲になるようにKpを決めた
//目標値:1.0(3.3倍した後の数値)
//センサー値:0~2の間くらい(3.3倍した後の数値)

enum branch_mode{//展開中の記憶記号
    STRAIGHT =0,
    RIGHT,
    LEFT,
    SHARP_R,
    SHARP_L,
    REVERSE
    };
    
int mode;
int pre_mode;

void Check_reflecter(AnalogIn sensor_R, AnalogIn sensor_L,AnalogIn sensor_C){
    int R_on_off =0;//左右の白黒
    int L_on_off =0;
    int C_on_off =0;  
    if(sensor_R*3.3F>R_target)
    {
        R_on_off=1;
    }
    if(sensor_L*3.3F>L_target)
    {
        L_on_off=1;
    }
    if(sensor_C*3.3F>C_target)
    {
        C_on_off=1;
    }
    printf("Judgement of sensor L[%d] C[%d] R[%d]\n",L_on_off,C_on_off,R_on_off);//[1]なら黒判定
    
    
    if(L_on_off==0 && C_on_off==0 && R_on_off==0)//線の外
    {
        printf("I'm going out of line! Previous condition is %d \n",pre_mode);
        mode = pre_mode;
    }
    else if(L_on_off==1 && C_on_off==0 && R_on_off==0)//急左折
    {
        mode = SHARP_L;
        printf("SHARP_L\n");
    }
    else if(L_on_off==0 && C_on_off==0 && R_on_off==1)//急右折
    {
        mode = SHARP_R;
        printf("SHARP_R\n");
    }
    else if(L_on_off==1 && C_on_off==0 && R_on_off==1)//黒白黒、エラー、back
    {
        mode = REVERSE;
        printf("REVERSE\n");
    }
    else if(L_on_off==0 && C_on_off==1 && R_on_off==0)//前進
    {
        mode = STRAIGHT;
        printf("STRAIGHT\n");
    }
    else if(L_on_off==1 && C_on_off==1 && R_on_off==0)//左折
    {
        mode = LEFT;
        printf("LEFT\n");
    }
    else if(L_on_off==0 && C_on_off==1 && R_on_off==1)//右折
    {
        mode = RIGHT;
        printf("RIGHT\n");
    }
    else if(L_on_off==1 && C_on_off==1 && R_on_off==1)//all black（空中or十字部)よって直進
    {
        mode = STRAIGHT;
        printf("STRAIGHT\n");
    }
    pre_mode = mode;
}
        
    
//条件分岐
void Conditional_branch(float duty_basic, float duty_ad, float duty_ad_sharp)
{
    if (mode == STRAIGHT)
    {
        machine_Forward(AIN1,AIN2,BIN1,BIN2,duty_basic);
    }
    else if (mode == LEFT)
    {
        Left_rotation(AIN1,AIN2,BIN1,BIN2,duty_basic,duty_ad);
    }
    else if (mode ==RIGHT)
    {
        Right_rotation(AIN1,AIN2,BIN1,BIN2,duty_basic,duty_ad);
    }
    else if (mode ==SHARP_L)
    {
        Left_high_rotation(AIN1,AIN2,BIN1,BIN2,duty_basic);
    }
    else if (mode ==SHARP_R)
    {
        Right_high_rotation(AIN1,AIN2,BIN1,BIN2,duty_basic);
    }
    else if (mode == REVERSE)
    {
        machine_Back(AIN1,AIN2,BIN1,BIN2,duty_basic);
    }
}
        


/*//モーターのp制御
void motor_p_control(PwmOut IN1,PwmOut IN2,AnalogIn sensor,float duty,float target,float gain){
            // P制御による旋回

            float turn = 0;
            turn = gain * (target- sensor*3.3F );
            
            if (0.15f < turn) {
                turn = 0.15;
            } else if (turn < -0.15f) {
                turn = -0.15;
            }
 
            printf("turn value:%f\n",turn);
            printf("speed value:%f\n",duty+turn);
        
            motorReverse(IN1,IN2,duty+turn);                                                                                                                                                                               
}
 
//マシンのp制御
void machine_p_control(AnalogIn sensor_R,AnalogIn sensor_L,AnalogIn sensor_C,float duty){
    float gain = p_gain;
    float L_duty = duty;
    float R_duty = duty;
    Conditional_branch(sensor_R,sensor_L,sensor_C,R_duty,L_duty,gain);
    motor_p_control(BIN1,BIN2,sensor_L,L_duty,L_target,gain);//左のモーター制御
    motor_p_control(AIN1,AIN2,sensor_R,R_duty,R_target,gain);//右のモーター制御
}

    
    
*/
int main() {    
    AIN1.period(0.01);
    AIN2.period(0.01);
    BIN1.period(0.01);
    BIN2.period(0.01);
    
    machine_Stop(AIN1,AIN2,BIN1,BIN2);
    mode = STRAIGHT;
    
      
 /*       enc_R.rise(&event_handler_R);
        enc_R.fall(&event_handler_R);
        enc_L.rise(&event_handler_L);
        enc_L.fall(&event_handler_L);
        */
      
    while(1) {
        wait(0.01);
        float duty_basic = 0.130f;
        float duty_ad = 0.02f;
        float duty_ad_sharp = 0.04f;
        Check_reflecter(sensor_R,sensor_L,sensor_C);
        Conditional_branch(duty_basic,duty_ad,duty_ad_sharp);
        printf("sensor_Right:L432[%.3f]>\n",sensor_R*3.3F);//電圧測定
        printf("sensor_Left:L432[%.3f]>\n",sensor_L*3.3F);//電圧測定
        printf("sensor_Center:L432[%.3f]>\n\n",sensor_C*3.3F);//電圧測定
     //   wait(2);
//      led_lightning(enc_R,enc_L,myled,i,distance);
    }
}