#include "mbed.h"


PwmOut AIN1(D6);
PwmOut AIN2(D5);
PwmOut BIN1(D9);
PwmOut BIN2(D10);


//ブレーキ
void motorStop(PwmOut IN1,PwmOut IN2) {
    IN1 = 1;
    IN2 = 1;
}

//逆転
void motorReverse(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = 0;
    IN2 = duty;
}

void motorForward(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = duty;
    IN2 = 0;
}

//空転
void motorIdling(PwmOut IN1,PwmOut IN2) {
    IN1 = 0;
    IN2 = 0;
}

void machine_Stop(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2) {
    motorStop(AIN1,AIN2);
    motorStop(BIN1,BIN2);
}

//前進
void machine_Forward(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty_R,float duty_L) {
    motorReverse(AIN1,AIN2,duty_R);//逆転のほうが制御しやすいので前進時は逆転を使用
    motorReverse(BIN1,BIN2,duty_L);
}

//後退
void machine_Back(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty_R,float duty_L) {
    machine_Stop(AIN1,AIN2,BIN1,BIN2);
    wait(2);
    motorForward(AIN1,AIN2,duty_R);
    motorForward(BIN1,BIN2,duty_L);
}

void machine_Idling(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2) {
    motorIdling(AIN1,AIN2);
    motorIdling(BIN1,BIN2);
}


InterruptIn enc_R(D12);//フォトインタラプタ右
InterruptIn enc_L(D11);//フォトインタラプタ左


float counter_R =0;
float pre_counter_R = 0; //左右の回転数変化量を読み取るための前値
void event_handler_R(void){
    counter_R++;
}

float counter_L =0;
float pre_counter_L = 0;
void event_handler_L(void){//左モーター
    counter_L++;
}
//AnalogIn photo(A0);
//AnalogIn schmitt(A5);
int main() {


        motorStop(AIN1,AIN2);
        motorStop(BIN1,BIN2);
        float pre_counter_R = 0;
        float pre_counter_L = 0;
        

    while(1) {//組み込み型のプログラムは無限ループになるようにする。（終わってはいけない）
    float duty = 0.40;
        enc_R.rise(&event_handler_R);
        enc_R.fall(&event_handler_R);
        enc_L.rise(&event_handler_L);
        enc_L.fall(&event_handler_L);
        printf("ready\n");
        wait(2);
        pre_counter_R = counter_R;
        pre_counter_L = counter_L;
        wait(1);
        float hosei = (counter_R-pre_counter_R)/(counter_L-pre_counter_L);
        
        printf("hosei = %f \ngo\n",hosei);
        for(duty;duty>0.0f;duty-=0.01f){
            machine_Forward(AIN1,AIN2,BIN1,BIN2,duty,duty);
            wait(1);//回転が安定するまで待つ
            pre_counter_R = counter_R;
            pre_counter_L = counter_L;
            wait(1);
            float R = (counter_R-pre_counter_R)/24.0f/38.2f;
            float proto_L = (counter_L-pre_counter_L)/24.0f/38.2f;
            float L = proto_L*hosei;
            printf("%f,%f,%f,%f\n",duty,R,L,proto_L);
            machine_Idling(AIN1,AIN2,BIN1,BIN2);
            wait(0.5f);
        }
    
    }
}
