#include "mbed.h"


PwmOut AIN1(D6);
PwmOut AIN2(D5);
PwmOut BIN1(D9);
PwmOut BIN2(D10);


//ブレーキ
void motorStop(PwmOut IN1,PwmOut IN2) {
    IN1 = 1;
    IN2 = 1;
}

//逆転
void motorReverse(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = 0;
    IN2 = duty;
}

InterruptIn enc_R(D12);//フォトインタラプタ右
InterruptIn enc_L(D11);//フォトインタラプタ左


float counter_R =0;
float pre_counter_R = 0; //左右の回転数変化量を読み取るための前値
void event_handler_R(void){
    counter_R++;
}

float counter_L =0;
float pre_counter_L = 0;
void event_handler_L(void){//左モーター
    counter_L++;
}
//AnalogIn photo(A0);
//AnalogIn schmitt(A5);
int main() {


        motorStop(AIN1,AIN2);
        motorStop(BIN1,BIN2);
        float pre_counter_R = 0;
        float pre_counter_L = 0;
        

    while(1) {//組み込み型のプログラムは無限ループになるようにする。（終わってはいけない）
    float duty = 0.50;

        motorReverse(AIN1,AIN2,duty);//逆転のほうが制御しやすいので前進時は逆転を使用
        motorReverse(BIN1,BIN2,duty);
        printf("ready\n");
        wait(3);
        printf("go\n");
        for(duty;duty>0.0;duty-=0.01){
            enc_R.rise(&event_handler_R);
            enc_R.fall(&event_handler_R);
            enc_L.rise(&event_handler_L);
            enc_L.fall(&event_handler_L);
            motorReverse(AIN1,AIN2,duty);//逆転のほうが制御しやすいので前進時は逆転を使用
            motorReverse(BIN1,BIN2,duty);
            wait(2);//回転が安定するまで待つ
            printf("duty value:%f\n",duty);
            printf("rotations per second(R_tire):%f\n",(counter_R-pre_counter_R)/24.0/38.2);//１秒間あたりのタイヤの回転数
            printf("rotations per second(L_tire):%f\n",(counter_L-pre_counter_L)/24.0/38.2);
            pre_counter_R = counter_R;
            pre_counter_L = counter_L;
        }
    
    }
}
