#include "mbed.h"

//走行用プログラムver2
//モータードライバー＋回転数計測プログラム
//走るためのプログラム+道が白か黒かを判定するプログラム
//A入力に右のモーター、B入力に左のモーター

InterruptIn enc_R(D12);//フォトインタラプタ右
InterruptIn enc_L(D11);//フォトインタラプタ左

AnalogIn sensor_R(A0);//進行方向右のフォトリフレクタセンサー    
AnalogIn sensor_L(A1);//進行方向左のセンサー
AnalogIn sensor_C(A2);//中央配置のセンサー

DigitalOut led(LED1);

int counter =0;

void event_handler(void){
    counter++;
    led =!led;
}


PwmOut AIN1(D6);
PwmOut AIN2(D5);
PwmOut BIN1(D9);
PwmOut BIN2(D10);
 
void motorStop(PwmOut IN1,PwmOut IN2) {
    IN1 = 1;
    IN2 = 1;
}
 
void motorForward(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = duty;
    IN2 = 0;
}
 
void motorReverse(PwmOut IN1,PwmOut IN2,float duty) {
    IN1 = 0;
    IN2 = duty;
}

//停止
void machine_Stop(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2) {
    motorStop(AIN1,AIN2);
    motorStop(BIN1,BIN2);
}

//前進
void machine_Forward(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {
    motorForward(AIN1,AIN2,duty);
    motorForward(BIN1,BIN2,duty);
}

//後退
void machine_Back(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {
    machine_Stop(AIN1,AIN2,BIN1,BIN2);
    motorReverse(AIN1,AIN2,duty);
    motorReverse(BIN1,BIN2,duty);
}

//右カーブ
void Right_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {
    motorForward(AIN1,AIN2,duty-0.2f);
    motorForward(BIN1,BIN2,duty);
}

//左カーブ
void Left_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {

    motorForward(AIN1,AIN2,duty);
    motorForward(BIN1,BIN2,duty-0.2f);
}


//右急カーブ
void Right_high_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {

    motorForward(AIN1,AIN2,duty-0.2f);
    motorForward(BIN1,BIN2,duty);
}

//左急カーブ
void Left_high_rotation(PwmOut AIN1,PwmOut AIN2,PwmOut BIN1,PwmOut BIN2,float duty) {

    motorForward(AIN1,AIN2,duty);
    motorForward(BIN1,BIN2,duty-0.2f);
}

//最終的には
//左のモーターのスピード = 比例ゲイン×（左のセンサ値 - 左の黒値） / （左の白値 - 左の黒値）＋基本最低スピード
//右のモーターのスピード = 比例ゲイン×（右のセンサ値 - 右の黒値） / （右の白値 - 右の黒値）＋基本最低スピード

//白値はセンサーで白を検出する最大値
//黒値はセンサーで黒を検出する最少値

int main() {
 
    
    while(1) {
        float duty = 0.9f;//デューティー比90%
        
        if(sensor_R*3.3f>1.0f&&sensor_L*3.3f>1.0f&&sensor_C>1.0f){//全部黒
            machine_Forward(AIN1,AIN2,BIN1,BIN2,duty);
            }
            
        else if(sensor_R*3.3f>1.0f&&sensor_L*3.3f<1.0f&&sensor_C>1.0f){//左センサーだけ白
            Right_rotation(AIN1,AIN2,BIN1,BIN2,duty);
            }
            
        else if(sensor_R*3.3f<1.0f&&sensor_L*3.3f>1.0f&&sensor_C>1.0f){//右センサーだけ白
            Left_rotation(AIN1,AIN2,BIN1,BIN2,duty); 
            }
            
        else if(sensor_R*3.3f>1.0f && sensor_L*3.3f>1.0f && sensor_C<1.0f){//中央センサーが白
            
            duty = 0.6f;//デューティー比60%
            machine_Forward(AIN1,AIN2,BIN1,BIN2,duty);//ゆっくり進む
            
            if(sensor_R*3.3f<1.0f && sensor_L*3.3f>1.0f && sensor_C<1.0f){//中央が出た後右センサーが出たら、左に急カーブ
                Left_high_rotation(AIN1,AIN2,BIN1,BIN2,duty);
            } 

            if(sensor_R*3.3f>1.0f && sensor_L*3.3f<1.0f && sensor_C<1.0f){//中央が出た後左センサーが出たら、右に急カーブ
                Right_high_rotation(AIN1,AIN2,BIN1,BIN2,duty);
            } 
        }
        else if(sensor_R*3.3f<1.0f&&sensor_L*3.3f<1.0f&&sensor_C<1.0f){//全部白（勢いがつきすぎて飛び出たなど）
            duty = 0.6f;//デューティー比60%
            machine_Back(AIN1,AIN2,BIN1,BIN2,duty);//ゆっくり後ろにさがる
        }
        printf("sensor_Right:L432[%.3f]>\n",sensor_R*3.3F);//電圧測定
        printf("sensor_Left:L432[%.3f]>\n",sensor_L*3.3F);//電圧測定
        printf("sensor_Center:L432[%.3f]>\n",sensor_C*3.3F);//電圧測定

    }
}