#include "mbed.h"
#include "rtos.h"
 
#include "Keypad.h"
 
Serial        PC(USBTX, USBRX);
RtosTimer    *LedTimer;
DigitalOut    Led1(LED1);
DigitalOut    Led2(LED2);
int input;
int break1;
bool start = false;
int freq = 1;
int wave = 1;
int range = 1;
int group_num = 0;
char id = '0'; 
CAN can1(p9,p10);
CANMessage talk;
// Define your own keypad values
char Keytable[] = { 
    '1', '2', '3', // r0
    '4', '5', '6', // r1
    '7', '8', '9', // r2
    '*', '0', '#' // r3
  // c0   c1  c2
 };
 
int32_t       Index = -1;
char           state='0';
 
uint32_t cbAfterInput(uint32_t _index)
{
    Index = _index;
    return 0;
}

void Send_Message() {
 
    PC.printf("\n Message Sending...\n");
    talk.data[0] = id;
    talk.data[1] = state;
    can1.write(talk);
    
    if(can1.write(talk))
    {
        PC.printf("Sent to id = %c with state = %c\n", talk.data[0], talk.data[1]);
        }
    
    PC.printf("Press # to go to main menu\n");
 }
 
void menu(){
    
    
    PC.printf("\n1. DAC Input\n");
    PC.printf("2. DigiPot Input\n");
    PC.printf("3. ADC Input\n");
}

int ADC()
{
    break1 = 0;
    Index = -1;
    PC.printf("\nSelect Start/Stop\n");
    PC.printf("1. Start\n");
    PC.printf("2. Stop\n");
    PC.printf("Press # to go to main menu\n");
    while (break1 != 1) {
        __wfi();
        if (Index > -1) {

            input = Index + 1;
            switch (input){
                case 1:
                    // start
                    state = '0';
                    PC.printf("Start case 1\n");
                    Send_Message();
                    break;
                case 2:
                    // stop
                    state = '1';
                    PC.printf("Stop case 2\n");
                    Send_Message();
                    break;
                case 12:
                    break1 =1;
                    menu();
                    break;
                default:
                    PC.printf("Please Select a Valid Input\n");
                    PC.printf("Select Start/Stop\n");
                    PC.printf("1. Start\n");
                    PC.printf("2. Stop\n");
                    PC.printf("Press # to go to main menu\n");
                    break;
                }
            
            
            Index = -1;
            
        }
        
    }
    return 0;
}
 


int DAC()
{
    break1 = 0;
    Index = -1;
    PC.printf("\nSelect Waveform Type\n");
    PC.printf("1. Turn Off\n");
    PC.printf("2. 1 Hz Square Wave\n");
    PC.printf("3. 10 Hz Square Wave\n");
    PC.printf("4. 1 Hz Sinusoidal Wave\n");
    PC.printf("5. 10 Hz Sinusoidal Wave\n");
    PC.printf("Press # to go to main menu\n");
    
    while (break1 != 1) {
        __wfi();
        if (Index > -1) {
          
            input = Index + 1;
            switch (input){
                case 1:
                    state = '1';
                    PC.printf("DAC = OFF\n");
                    Send_Message();
                    break;
                case 2:
                    state = '2';
                    PC.printf("1 Hz Square Wave\n");
                    Send_Message();
                    break;
                case 3:
                    state = '3';
                    PC.printf("10 Hz Square Wave\n");
                    Send_Message();
                    break;
                case 4:
                    state = '4';
                    PC.printf("1 Hz Sinusoidal Wave\n");
                    Send_Message();
                    break;
                case 5:
                    state = '5';
                    PC.printf("10 Hz Sinusoidal Wave\n");
                    Send_Message();
                    break;
                case 12:
                    break1 =1;
                    menu();
                    break;
                default:
                    PC.printf("Please Input a Valid Input\n");
                    PC.printf("Select Waveform Type\n");
                    PC.printf("1. Turn Off\n");
                    PC.printf("2. 1 Hz Square Wave\n");
                    PC.printf("3. 10 Hz Square Wave\n");
                    PC.printf("4. 1 Hz Sinusoidal Wave\n");
                    PC.printf("5. 10 Hz Sinusoidal Wave\n");
                    PC.printf("Press # to go to main menu\n");
                    break;
                }
            
            
            Index = -1;
            
        }
        
    }
    return 0;
}

int DigiPot(){
    break1 = 0;
    Index = -1;
    PC.printf("\nSelect Range\n");
    PC.printf("1. Between 0 to 1\n");
    PC.printf("2. Between 0 to 2\n");
    PC.printf("3. Between 0 to 3\n");
    PC.printf("4. Between 0 to 4\n");
    PC.printf("5. Between 0 to 5\n");
    PC.printf("Press # to go to main menu\n");
    while (break1 != 1) {
        __wfi();
        if (Index > -1) {

            input = Index + 1;
            switch (input){
                case 1:
                    state = '1';
                    PC.printf("0V to 1V\n");
                    Send_Message();
                    break;
                case 2:
                    state = '2';
                    PC.printf("0V to 2V\n");
                    Send_Message();
                    break;
                case 3:
                    state = '3';
                    PC.printf("0V to 3V\n");
                    Send_Message();
                    break;
                case 4:
                    state = '4';
                    PC.printf("0V to 4V\n");
                    Send_Message();
                    break;
                case 5:
                    state = '5';
                    PC.printf("0V to 5V\n");
                    Send_Message();
                    break;
                case 12:
                    break1 =1;
                    menu();
                    break;
                default:
                    PC.printf("Please Input a Valid Input\n");
                    PC.printf("Select Range\n");
                    PC.printf("1. Between 0 to 1\n");
                    PC.printf("2. Between 0 to 2\n");
                    PC.printf("3. Between 0 to 3\n");
                    PC.printf("4. Between 0 to 4\n");
                    PC.printf("5. Between 0 to 5\n");
                    PC.printf("Press # to go to main menu\n");
                    break;
                }
            
            
            Index = -1;
            
        }
        
    }
    return 0;
}

 
int main()
{
    
    PC.printf("\nControl Menu\r\n");  
    menu();
    
    //             r0   r1   r2   r3   c0   c1   c2   c3
    Keypad keypad(p21, p22,  p23,  p24, p25, p26,  p27,  NC);
    keypad.attach(&cbAfterInput);
    keypad.start();  // energize the columns c0-c3 of the keypad
 
    while (1) {
        __wfi();
         
    
        if (Index > -1) {

            group_num = Index + 1;
            switch (group_num){
                case 1:
                    PC.printf("Calling DAC()... \n");
                    id = '1';
                    DAC();
                    
                    break;
                case 2:
                    PC.printf("Calling DigiPot()... \n");
                    id = '2';
                    DigiPot();
                    break;
            
                case 3:
                    PC.printf("Calling ADC()... \n");
                    id = '3';
                    ADC();
                    break;
                default:
                    PC.printf("Please Enter a Valid Input between 1 - 3\n");
                    menu();
                    break;
            }
            
            Index = -1;
            
        }
    }
}