#include "mbed.h"
#include "MFRC522.h"
#define MF_RESET    D8
Serial pc(SERIAL_TX, SERIAL_RX);
Serial tu(PA_11, PA_12);
MFRC522    RfChip   (PC_12, PC_11, PC_10, PC_8, MF_RESET);
DigitalOut LedGreen(LED1);

int main(void) {

  pc.printf("starting...\n");

  RfChip.PCD_Init();

  uint8_t ID[8];
  uint8_t ID1[8]={0x3B,0xED,0x13,0x80};//Wan
  uint8_t ID2[8]={0x4B,0xA9,0x14,0x80};//Gus
  uint8_t ID3[8]={0x5B,0x18,0x12,0x80};//Wisa
  uint8_t ID4[8]={0x3B,0x1A,0x12,0x80};//Tew

  while (true) {
    LedGreen = 1;
    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }

    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }

    LedGreen = 0;
    // Print Card UID

    pc.printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      pc.printf(" %X", RfChip.uid.uidByte[i]);
      ID[i]=RfChip.uid.uidByte[i];
    }
    pc.printf("\n\r");
    if (ID[0]==ID1[0]&&ID[1]==ID1[1]&&ID[2]==ID1[2]&&ID[3]==ID1[3]){
        pc.printf("Wan's Card\n");
        tu.printf("G");
        }
    else if(ID[0]==ID2[0]&&ID[1]==ID2[1]&&ID[2]==ID2[2]&&ID[3]==ID2[3]){
        pc.printf("Gus's Card\n");
        tu.printf("J");
        }
    else if(ID[0]==ID3[0]&&ID[1]==ID3[1]&&ID[2]==ID3[2]&&ID[3]==ID3[3]){
        pc.printf("Wisa's Card\n");
        tu.printf("H");
        }
    else if(ID[0]==ID4[0]&&ID[1]==ID4[1]&&ID[2]==ID4[2]&&ID[3]==ID4[3]){
        pc.printf("Tew's Card\n");
        tu.printf("K");
        }
    else{
        return (0);
        }
  }
}
