﻿using org.mbed.RPC;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;



namespace team_project
{
    public partial class current_lable_status : Form
    {
        string selectedPort;
        SerialRPC _serialRPC;    // embed rpc handle
        RPCVariable<int> times_of_function_called;
        private Timer timer1; 
        private bool is_set_timer;
        private int counter;
        /******************Test serial call back*******************/
        StringComparer stringComparer = StringComparer.OrdinalIgnoreCase;
        delegate void SetTextCallback(string text);      

        int current_run,current_label;        
        /*************************************/
        public current_lable_status()
        {
            InitializeComponent();
            //get list of active ports on the computer
            string[] ports = SerialPort.GetPortNames();
            serialComboBox.Items.AddRange(ports);
            for (int i = 0; i < ports.Length; i++) 
            {                                   
                if (ports[i].IndexOf("COM") != -1 & ports[i].IndexOf("COM1") == -1) 
                {                    
                    serialComboBox.SelectedItem = ports[i];
                    break;
                }
            }
                
            this.init_button();
            this.InitTimer();            
            groupBox1.Enabled = false;
            groupBox2.Enabled = false;           
            groupBox3.Enabled = false;
            groupBox6.Enabled = false;
            train_button.Enabled = false;
            current_label = 0;
            current_run = 1;
            counter = 0;
            is_set_timer = false;
        }

        ~current_lable_status()
        {
            try
            {
                //delete objects before exit            
                string[] arg = { };
                if (_serialRPC != null) _serialRPC.delete();
                Debug.Print("Complete");
            }
            catch (NullReferenceException ex)
            {
                Debug.Print("No Reference: " + ex.Message);
            }

            this.Close();
        }

        private void SerialRPCForm_Load(object sender, EventArgs e)
        {
            //disable controls until com port is connected
            groupBox2.Enabled = true;
            startButton.Enabled = true;
            //initialize status variables           
            statusLabel.Text = "Not connected!";
        }

        private void serialComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {            
            selectedPort = serialComboBox.SelectedItem.ToString();
        }


        //start button
        private void startButton_Click_1(object sender, EventArgs e)
        {
            if (startButton.Text == "Disconnect")
            {
                startButton.Text = "Connect";
                _serialRPC.delete();
                statusLabel.Text = "Not connected!";
                serialComboBox.Enabled = true;                                
                groupBox3.Enabled = false;
                groupBox1.Enabled = false;
                groupBox6.Enabled = false; 
                return;
            }
            
            try
            {
                //Create an mbed object for communication over USB (serial)
                _serialRPC = new SerialRPC(selectedPort, 115200);
                _serialRPC.mbedSerialPort.DataReceived += new SerialDataReceivedEventHandler(DataReceivedHandler);
                times_of_function_called = new RPCVariable<int>(_serialRPC, "times_of_function_called");
              
                //enable controls after com port is connected
                startButton.Enabled = true;
                groupBox2.Enabled = true;
                serialComboBox.Enabled = false;
                statusLabel.Text = "Mbed connected to " + selectedPort;
                groupBox3.Enabled = true;
                groupBox1.Enabled = true;
                groupBox6.Enabled = true;
                startButton.Text = "Disconnect";

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString(), "Error!", MessageBoxButtons.OK, MessageBoxIcon.Error);
                if (_serialRPC != null) _serialRPC.delete();
                statusLabel.Text = "Not connected!";
            }
        }

        private void stopButton_Click(object sender, EventArgs e)
        {
            
        }       

        /*
         * private void file_write(string path, string data)
        {
            if (!File.Exists(path))
            {
                this.file_generate(path);                
            }           
            string[] stringSeparators = new string[] {","};
            string[][] output = new string[][] { };
            string[] x = data.Split(stringSeparators, StringSplitOptions.None);
            int i =0;
            int j;
            for (j = 0; j < x.Length;j++ )
            {
                output[i][j] = x[j];
                if (j == 24) i++;
            }
            int length = x.GetLength(0);
            StringBuilder sb = new StringBuilder();
            sb.AppendLine(string.Join(",", x));
            File.AppendAllText(path, sb.ToString());           
        }
         */

        private void DataReceivedHandler(object sender, SerialDataReceivedEventArgs e)
        {
            SerialPort ssp = (SerialPort)sender;
            string indata = ssp.ReadLine();           
            this.show_serial_data2(indata);
            this.show_serial_data(indata);
            int idx_train = textBox1.Text.IndexOf("train_svm");            
            int idx_reset = textBox1.Text.IndexOf("reset_train_data");
            int idx_confirm = textBox1.Text.IndexOf("collect_train_data");           
            int idx_predict = textBox1.Text.IndexOf("predict_svm");
            int idx_collect_emf = textBox1.Text.IndexOf("collect_emf_data");
            /*
            int idx_emf = textBox1.Text.IndexOf("save emf");
            int idx_raw = textBox1.Text.IndexOf("save raw");
            int idx_train_data = textBox1.Text.IndexOf("save train data");
            int idx_train_model = textBox1.Text.IndexOf("save train model");
             */
            if (idx_train != -1) this.train_finished();         
            else if (idx_reset != -1) this.idx_reset();
            else if (idx_confirm != -1) this.idx_confirm();
            else if (idx_predict != -1) this.idx_predict(idx_predict);
            else if (idx_collect_emf != -1) this.idx_collect_emf();

        }

        

        private void file_generate(string filePath)
        {
            string delimiter = ",";
            string[][] output = new string[][]{  
                new string[]{"time", "m1.x", "m1.y","m1.z","a1.x","a1.y","a1.z","m2.x", "m2.y","m2.z","a2.x","a2.y","a2.z","m3.x", "m3.y","m3.z","a3.x","a3.y","a3.z","m4.x", "m4.y","m4.z","a4.x","a4.y","a4.z"}, 
                //new string[]{string.Format("{0:hh:mm:ss}",DateTime.Now), "magnetic_1.x", "magnetic_1.y", "magnetic_1.z", "gravity1.x","gravity1.y","gravity1.z","magnetic_1.x", "magnetic_1.y", "magnetic_1.z", "gr
                //new string[]{"m1.x", "m1.y","m1.z","a1.x","a1.y","a1.z","m2.x", "m2.y","m2.z","a2.x","a2.y","a2.z","m3.x", "m3.y","m3.z","a3.x","a3.y","a3.z","m4.x", "m4.y","m4.z","a4.x","a4.y","a4.z"}
            };
            int length = output.GetLength(0);
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < length; index++)
                sb.AppendLine(string.Join(delimiter, output[index]));
            File.WriteAllText(filePath, sb.ToString());
        }

        private void file_write(string path, string data)
        {
            if (!File.Exists(path))
            {
                this.file_generate(path);                
            }
            string[] stringSeparators = new string[] {","}; 
            string[] x = data.Split(stringSeparators, StringSplitOptions.None);
            int j;
            for (j = 0; j < x.Length;j++ )
            {
                if (j == 0) x[j] = string.Format("{0:hh:mm:ss}", DateTime.Now) + "," + x[j];
                if (j % 24 == 0 & j > 0) x[j] = Environment.NewLine  + string.Format("{0:hh:mm:ss}", DateTime.Now) + ","+ x[j];            
            }
            StringBuilder sb = new StringBuilder();            
            sb.AppendLine(string.Join(",", x));
            File.AppendAllText(path, sb.ToString());           
        }

        private void train_finished()
        {
            string message = "Train finished";
            string caption = "Message";
            MessageBoxButtons buttons = MessageBoxButtons.OK;
            DialogResult result;
            //result = MessageBox.Show(message, caption, buttons);
            enable_button("train_button");
            this.clean_serial_data("");
            this.show_serial_data2("train_svm");
        }


        private void idx_collect_emf()
        {
            show_serial_data2("collect_emf_data");
            this.clean_serial_data("");
        }

        private void idx_reset() 
        {
         
            enable_button("Confirmation_button");
            this.clean_serial_data("");
        }
        private void idx_confirm()
        {
            int num_of_points = 0;
            int repeat_times = 0;
            int num_of_labels = 0;
            //this.clean_serial_data("");
            Int32.TryParse(num_of_point_reset.Text, out num_of_points);
            Int32.TryParse(num_of_label_reset.Text, out num_of_labels);
            Int32.TryParse(repeat_time_reset.Text, out repeat_times);
            //if (!(this.current_run == (repeat_times ) && this.current_label == (num_of_labels-1))) enable_button("Confirmation_button");
            //MessageBox.Show(counter.ToString());
            if (counter > 0) enable_button("Confirmation_button");
            else enable_button("train_button");
            if (this.current_run == (repeat_times+1) && this.current_label == 0)
            {
                show_current_label((num_of_labels-1).ToString());
                //show_current_point(repeat_time_reset.Text);
            }
            else 
            {
                show_current_label(this.current_label.ToString());
                //show_current_point((this.current_run).ToString());
            }                        
        }
        //update test Label
        private void show_current_label_status(string s)
        {
            if (this.current_label_status.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(show_current_label_status);
                this.Invoke(d, new object[] { s });

            }
            else
            {
                this.current_label_status.Text = s;
            }
        }
        //collect data from predict_svm, then show Label
        private void idx_predict(int idx)
        {
            show_serial_data2(textBox1.Text);           
            string data = textBox1.Text.Substring(idx+12, 1);
            string[] stringSeparators = new string[] { " " };
            string[] x = data.Split(stringSeparators, StringSplitOptions.None);            
            this.clean_serial_data("");
            this.show_current_label_status(data);
        }        

        private void enable_button(string str)
        {
            if (this.confirmation_textBox.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(enable_button);
                this.Invoke(d, new object[] {str });

            }
            else
            {
                if (str == "Confirmation_button")
                    this.Confirmation_button.Enabled = true;
                else if (str == "train_button") { train_button.Enabled = true;}
            }          
        }
        //show the current confirmaion label
        private void show_current_label(string label) 
        {
            if (this.confirmation_textBox.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(show_current_label);
                this.Invoke(d, new object[] { label });

            }
            else
            {
                this.confirmation_textBox.Text = "Label = "+label;
            }
        }


        private void show_current_point(string label)
        {
            if (this.confirmation_textBox.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(show_current_point);
                this.Invoke(d, new object[] { label });

            }
            else
            {
                //this.confirmation_textBox2.Text = "Current runs = " + label;
            }
        }


        public void show_serial_data(string s) {
            if (this.textBox1.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(show_serial_data);
                this.Invoke(d, new object[] { s });

            }
            else
            {
                this.textBox1.Text += s ;
            }

        }

        private void clean_serial_data(string s)
        {
            if (this.textBox1.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(clean_serial_data);
                this.Invoke(d, new object[] { "" });

            }
            else
            {
                this.textBox1.Text = "";
            }
        }

        //collect all incomming data
        public void show_serial_data2(string s)
        {
            if (this.debug_textBox.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(show_serial_data2);
                this.Invoke(d, new object[] { s });
                //MessageBox.Show("invoke");

            }
            else
            {
                //MessageBox.Show("non-invoke");
                this.debug_textBox.Text += s;
            }

        }

        private void reset_train_button_Click_1(object sender, EventArgs e)
        {
            int repeat_time = 0;
            int num_of_points = 0;
            int num_of_label = 0;
            this.current_run = 1;
            this.current_label = 0;
            textBox1.Text = "";
            progressBar.Value = 0;
            Int32.TryParse(repeat_time_reset.Text, out repeat_time);
            Int32.TryParse(num_of_point_reset.Text, out num_of_points);
            Int32.TryParse(num_of_label_reset.Text, out num_of_label);
            counter = repeat_time * num_of_label;
            string[] args = { };
            _serialRPC.RPC("reset_train_data", "run", args);
            this.confirmation_textBox.Text = "Label = " + current_label;
       }


        private void train_button_Click_1(object sender, EventArgs e)
        {
            textBox1.Text = "";
            string[] args = { };
            _serialRPC.RPC("train_svm", "run", args);
            //groupBox6.Enabled = true;
                               
        }

        private void Confirmation_button_Click(object sender, EventArgs e)
        {            
            int num_of_points = 0;
            int repeat_times = 0;
            int num_of_labels = 0;
            Int32.TryParse(num_of_point_reset.Text, out num_of_points);
            Int32.TryParse(num_of_label_reset.Text, out num_of_labels);
            Int32.TryParse(repeat_time_reset.Text, out repeat_times);
            textBox1.Text = "";
            string[] args = { this.current_label.ToString(), num_of_points.ToString() };
            _serialRPC.RPC("collect_train_data", "run", args);
            Confirmation_button.Enabled = false;
            
            counter--;
            if (this.current_label % (num_of_labels-1) == 0 & current_label >= 1)
            {

                this.current_run++;
                this.current_label = 0;
            }
            else 
            {
                this.current_label++;
            }
               
            //MessageBox.Show(current_label.ToString(), "Error!", MessageBoxButtons.OK, MessageBoxIcon.Error);            
            progressBar.Maximum = repeat_times * num_of_labels;     
            progressBar.Step = 1; 
            
            this.confirmation_textBox.Text = "Label = " + current_label;          
            progressBar.PerformStep();            
        }
        /*
        private void store_emf(int idx)
        {
            string data = textBox1.Text.Substring(0, idx);
            string filePath;
            if (string.IsNullOrWhiteSpace(file_location.Text)) filePath = @"Z:\4180\emf_data" + DateTime.Now.ToString("_MM_dd_HH_mm") + ".csv";
            else filePath = @file_location.Text +"emf_data"+ DateTime.Now.ToString("_MM_dd_HH_mm") + ".csv";
            this.file_write(filePath, data);

        }

        private void store_raw(int idx)
        {
            string data = textBox1.Text.Substring(0, idx);
            string filePath;
            if (string.IsNullOrWhiteSpace(file_location.Text)) filePath = @"Z:\4180\raw_data" + DateTime.Now.ToString("_MM_dd_HH_mm") + ".csv";
            else filePath = @file_location.Text + "raw_data" + DateTime.Now.ToString("_MM_dd_HH_mm") + ".csv";
            this.file_write(filePath, data);
        }

        private void store_train_data(int idx)
        {
            string data = textBox1.Text.Substring(0, idx);
            string filePath;
            if (string.IsNullOrWhiteSpace(file_location.Text)) filePath = @"Z:\4180\train_data" + DateTime.Now.ToString("_MM_dd_HH_mm") + ".txt";
            else filePath = @file_location.Text + "train_data" + DateTime.Now.ToString("_MM_dd_HH_mm") + ".txt";                     
            File.WriteAllText(filePath, data);


        }

        private void store_train_model(int idx)
        {
            string data = textBox1.Text.Substring(0, idx);
            string filePath;
            if (string.IsNullOrWhiteSpace(file_location.Text)) filePath = @"Z:\4180\train_model" + DateTime.Now.ToString("_MM_dd_HH_mm") + ".mod";
            else filePath = @file_location.Text + "train_model" + DateTime.Now.ToString("_MM_dd_HH_mm") + ".mod";
            File.WriteAllText(filePath, data);
        }
        */
        private void button3_Click(object sender, EventArgs e)
        {   
            //store EMF data
            textBox1.Text = "";
            string[] args = {"0"};
            _serialRPC.RPC("save", "run", args);
        }

        private void button6_Click(object sender, EventArgs e)
        {
            //Stroe train.txt
            textBox1.Text = "";
            string[] args = {"1"};
            _serialRPC.RPC("save", "run", args);
        }

        private void button7_Click(object sender, EventArgs e)
        {
            //stroe Train model
            textBox1.Text = "";
            string[] args = {"2"};
            _serialRPC.RPC("save", "run", args);
        }

        private void button5_Click(object sender, EventArgs e)
        {   
            //Store raw data
            textBox1.Text = "";
            string[] args = {"3"};
            _serialRPC.RPC("save", "run", args);
        }

        private void test_button_Click(object sender, EventArgs e)
        { 
            
             if(test_button.Text == "start")
            {
                if (!is_set_timer)
                {                   
                   this.is_set_timer = true;
                   int freq;
                   Int32.TryParse(freqence_textBox.Text, out freq);
                   timer1.Interval = freq;
                   this.timer1.Start();
                   groupBox1.Enabled = false;
                   groupBox2.Enabled = false;
                   groupBox3.Enabled = false;
                   freqence_textBox.Enabled = false;
                }
                test_button.Text = "stop";
            }
            else
            {
                if (is_set_timer)
                {
                    this.timer1.Stop();
                    this.is_set_timer = false;
                    groupBox1.Enabled = true;
                    groupBox2.Enabled = true;
                    groupBox3.Enabled = true;
                    freqence_textBox.Enabled = true;
                }
                test_button.Text = "start";
            }            
        }       
        public void InitTimer()
        {
            timer1 = new Timer();
            timer1.Tick += new EventHandler(timer1_Tick);
            timer1.Interval = 1000; // in miliseconds                   
        }
        private void timer1_Tick(object sender, EventArgs e)
        {
            string[] args = {};
            _serialRPC.RPC("predict_svm", "run", args);
        }

        private void stop_Click(object sender, EventArgs e)
        {
            timer1.Stop();
            this.is_set_timer = false;
        }

        private void current_label_status_TextChanged(object sender, EventArgs e)
        {

        }
        private void init_button()
        {
            current_label_status.ReadOnly = true;
            current_label_status.ForeColor = Color.Black;
            current_label_status.BackColor = Color.White;

            confirmation_textBox.ReadOnly = true;
            confirmation_textBox.ForeColor = Color.Black;
            confirmation_textBox.BackColor = Color.White;

            debug_textBox.ReadOnly = true;
            debug_textBox.ForeColor = Color.Black;
            debug_textBox.BackColor = Color.White;
            
        }
        
        private void emf_button_Click(object sender, EventArgs e)
        {
            string[] args = { };
            _serialRPC.RPC("collect_emf_data", "run", args);
        }


      


        
        
    }
}
