/*
 * example program for TFTPServer class
 *
 * How to use:
 * -> change the IP to something that works for you
 * -> connect to the mbed with a TFTP client in binary(octet) mode
 * -> use (s)uspend and (r)esume keys to turn TFTP server on/off
 * -> upload any file, but .bin files are always put on the internal 
 *    memory, as are config.txt files
 * 
 * Copyright (c) 2011 Jaap Vermaas
 *
 *   This file is part of the LaOS project (see: http://wiki.laoslaser.org
 *
 *   LaOS is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   LaOS is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with LaOS.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "mbed.h"
#include "SDFileSystem.h"
#include "TFTPServer.h"
#include "EthernetNetIf.h"
LocalFileSystem local("local"); // defining this makes MBED internal mem accessible

TFTPServer *srv;        // define the TFTP Server
Timer t;                // used in main() to send debug output every 2 seconds
Serial *serial;         // serial just for debugging
//SDFileSystem sd(p11, p12, p13, p14, "sd"); // only needed if you save to SD card
SDFileSystem sd(p8, p22, SPI(p5, p6, p7), "sd", SDFileSystem::SWITCH_NEG_NO, 25000000);
EthernetNetIf *eth;     // network device

int main() {
    
    // configure serial terminal
    serial = new Serial(USBTX, USBRX);
    serial->baud(115200);

    // set up networking
    eth = new EthernetNetIf(
        IpAddr(192,168,1,111),  //IP Address
        IpAddr(255,255,255,0),  //Network Mask
        IpAddr(192,168,1,1),    //Gateway
        IpAddr(192,168,1,1)     //DNS
    );
    eth->setup();
    
    // test SD card (TFTP server can work without it)
    printf("\rTEST SD...\r\n");
    FILE *fp = fopen("/sd/test.txt", "wb");
    if ( fp == NULL )
        printf("SD: NOT READY\n\r");
    else {
        printf("SD: READY...\n\r");
        fclose(fp);
    }
    remove("/sd/test.txt");

    // start tftp server with the work dir as a comment
    // use "/local/" for the internal mbed device
    srv = new TFTPServer("/sd/");

    t.start();
    int filecounter = 0;    // incoming files
    char filename[256];     // to display filenames
    while (1) {
        Net::poll();
        if (serial->readable()) {
            int c = serial->getc();
            switch (c) {
                case 's': 
                    srv->suspend();
                    break;
                case 'r':
                    srv->resume();
                    break;
            }
        }
       
        if (srv->fileCnt() > filecounter) {
            filecounter = srv->fileCnt();
            srv->getFilename(filename);
            printf("new file: %s\n\r", filename);
        }
        if (t.read() > 2) {
            t.reset();
            TFTPServerState state = srv->State();
            switch(state) {
                case listen:
                    printf("MAIN: TFTP listen\n\r");
                    break;
                case reading:
                    srv->getFilename(filename);
                    printf("MAIN: TFTP reading file: %s\n\r", filename);
                    break;
                case writing:
                    srv->getFilename(filename);
                    printf("MAIN: TFTP writing file: %s\n\r", filename);
                    break;
                case error:
                    printf("MAIN: TFTP error\n\r");
                    break;
                case suspended:
                    printf("MAIN: TFTP suspended\n\r");
                    break;
                default:
                    printf("MAIN: Unknown TFTP status\n\r");
                    break;
            }
        }
    }
}

