% Copyright (c) 2010 ARM Ltd
%  
% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to deal
% in the Software without restriction, including without limitation the rights
% to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
% copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%  
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.
%  
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
% OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
% THE SOFTWARE.

%This is a script that demonstrates the use of the accompanying library of MATLAB 
%clases. It will display a sine wave 90 degrees out of phase on each of the mbeds LEDs,
%Wire p19 low for the program to run and pull it high to cause the program
%to exit.
%Note that a program must be running on mbed which receives the RPC
%commands

%Create an mbed object on the desired transport mechanism (Serial) with the
%appropriate arguments
mbed = mbedSerial('COM5', 9600);

%Create objects on mbed - note that the mbed object you want to create them on is
%passsed as an argument
led1 = PwmOut(mbed, LED1);
led2 = PwmOut(mbed, LED2);
led3 = PwmOut(mbed, LED3);
led4 = PwmOut(mbed, LED4);
din = DigitalIn(mbed, p20);

%create a vector containing all the points on a sine wave
x = 1:1:700;
y = ((sin(x * pi /180))+1)/2;
i = 1;

%read the value from the digital input using din.read
while din.read == 0 
    %Write the values to each of the PWMs
    led1.write(y(i));
    led2.write(y(i + 90));
    led3.write(y(i + 180));
    led4.write(y(i + 270));
    pause(0.025);
    i = i + 10;
    if i == 361
        i = 1;
    end    
end

%Call delete to close the connection which in this case releases the serial
%port so its avaliable to other applications
mbed.delete
clear;